<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Permissions
{
    public static function getPermissions()
    {
        return array(
            'canCreate'=>self::canCreateBanner(),
            'canCreateZone'=>self::canCreateZone(),
            'canSeeEmbedButton'=>self::canSeeEmbedButtonBanner(),
            'canEditActive'=>self::canEditActiveBanner()
        );
    }

    public static function isExcludedUsergroup()
    {
        return XenForo_Visitor::getInstance()->isMemberOf(
            XenForo_Application::getOptions()->get('xcas_excluded_usergroups')
        );
    }

    public static function isAdmin()
    {
        return XenForo_Visitor::getInstance()->hasAdminPermission('xcas_manage_ads');
    }

    public static function canUse()
    {
        return XenForo_Visitor::getInstance()->hasPermission('xcas', 'can_use');
    }

    public static function canSkipModeration()
    {
        return XenForo_Visitor::getInstance()->hasPermission('xcas', 'can_skip_moderation');
    }

    public static function canCreateBanner()
    {
        return XenForo_Visitor::getInstance()->hasPermission('xcas', 'can_create_ads');
    }
    public static function canCreateZone()
    {
        return XenForo_Visitor::getInstance()->hasPermission('xcas', 'can_create_zones');
    }


    public static function canEditActiveBanner()
    {
        return XenForo_Visitor::getInstance()->hasPermission('xcas', 'can_edit_active_ads');
    }
    public static function canSeeEmbedButtonBanner()
    {
        return XenForo_Visitor::getInstance()->hasPermission('xcas', 'can_see_embed_button');
    }
}